﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaIntegration.Cache.Commands
{
    public class CacheCommandQueries
    {
        #region EIS

        public const string HOSPITAL_LOCATION_QUERY = @"SELECT TOP [ROW_COUNT] HL.IEN, HL.NAME, HL.ABBREVIATION, HL.TELEPHONE,
                                                                WL.IEN AS WARD_IEN, WL.NAME AS WARD_NAME, WL.SPECIALTY AS WARD_SPECIALTY_IEN, WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME, 
                                                                WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE
                                                        FROM [SCHEMA].HOSPITAL_LOCATION AS HL
                                                                LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.HOSPITAL_LOCATION_FILE_POINTER = HL.IEN
                                                            WHERE HL.%ID > [FROM_IEN]
                                                            ORDER BY HL.%ID";

        public const string WARD_LOCATION_QUERY = @"SELECT TOP [ROW_COUNT] IEN AS WARD_IEN, NAME AS WARD_NAME, SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                SPECIALTY_NAME AS WARD_SPECIALTY_NAME, CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE
                                                    FROM [SCHEMA].WARD_LOCATION
                                                    WHERE %ID > [FROM_IEN]
                                                    ORDER BY %ID";

        public const string ROOM_BED_QUERY = @"SELECT TOP [ROW_COUNT] RB.IEN, RB.NAME, RB.CURRENTLY_OUTOFSERVICE, W.IEN AS WARD_IEN, WL.NAME AS WARD_NAME, WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                            WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME, WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE, 
                                                            CAST(O.OUTOFSERVICE_DATE AS DATETIME) AS OUT_OF_SERVICE_DATE, RB.BED_HOLD, RB.BED_HOLD_DATE
                                                FROM [SCHEMA].ROOMBED AS RB
                                                    INNER JOIN [SCHEMA].WARDS_WHICH_CAN_ASSIGN AS W ON RB.IEN = W.ROOMBED
                                                    LEFT JOIN [SCHEMA].OUTOFSERVICE_DATE AS O ON RB.IEN = O.ROOMBED 
                                                                AND (CAST(O.RETURN_TO_SERVICE_DATE AS DATETIME) >= GETDATE() OR CAST(O.RETURN_TO_SERVICE_DATE AS DATETIME) IS NULL)
                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON W.IEN = WL.IEN                                                    
                                                WHERE RB.%ID > [FROM_IEN]
                                                ORDER BY RB.%ID";

        public const string PATIENT_QUERY = @"SELECT TOP [ROW_COUNT] P.IEN AS PATIENT, P.NAME AS PATIENT_NAME, P.SEX AS PATIENT_SEX, CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                            P.SOCIAL_SECURITY_NUMBER, P.f1U4N, P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                            PM.DIAGNOSIS_SHORT AS DIAGNOSIS, P.SERVICE_CONNECTED_PERCENTAGE, P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                            P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
                                                FROM [SCHEMA].PATIENT AS P
                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN 
                                                WHERE P.%ID > [FROM_IEN] AND CAST(P.DATE_ENTERED_INTO_FILE AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND CAST(P.DATE_ENTERED_INTO_FILE AS DATETIME) <= CAST([END_DATE] AS DATETIME)
                                                ORDER BY P.%ID";

        public const string PATIENT_BY_IEN_QUERY = @"SELECT P.IEN AS PATIENT, P.NAME AS PATIENT_NAME, P.SEX AS PATIENT_SEX, CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                            P.SOCIAL_SECURITY_NUMBER, P.f1U4N, P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                            PM.DIAGNOSIS_SHORT AS DIAGNOSIS, P.SERVICE_CONNECTED_PERCENTAGE, P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                            P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
                                                FROM [SCHEMA].PATIENT AS P
                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN 
                                                WHERE P.IEN = [PATIENT_IEN]";

        public const string PATIENT_BY_SSNS_QUERY = @"SELECT P.IEN AS PATIENT, P.NAME AS PATIENT_NAME, P.SEX AS PATIENT_SEX, CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                            P.SOCIAL_SECURITY_NUMBER, P.f1U4N, P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                            PM.DIAGNOSIS_SHORT AS DIAGNOSIS, P.SERVICE_CONNECTED_PERCENTAGE, P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                            P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
                                                FROM [SCHEMA].PATIENT AS P
                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN 
                                                WHERE P.SOCIAL_SECURITY_NUMBER IN ([PATIENT_SSNS])";

        public const string NEW_PERSON_QUERY = @"SELECT TOP [ROW_COUNT] IEN, NAME 
                                                    FROM [SCHEMA].NEW_PERSON
                                                        WHERE %ID > [FROM_IEN] AND CAST(DATE_ENTERED AS DATETIME) > CAST([START_DATE] AS DATETIME) AND CAST(DATE_ENTERED AS DATETIME) < CAST([END_DATE] AS DATETIME)
                                                        ORDER BY %ID";

        #endregion

        #region EVS

        public const string MEDICAL_CENTER_DIVISION_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                                    NAME, 
                                                                                    FACILITY_NUMBER 
                                                                FROM [SCHEMA].MEDICAL_CENTER_DIVISION
                                                                    WHERE %ID > [FROM_IEN]
                                                                    ORDER BY %ID";        

        public const string FACILITY_TREATING_SPECIALTY_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                                        NAME, 
                                                                                        SPECIALTY 
                                                                    FROM [SCHEMA].FACILITY_TREATING_SPECIALTY
                                                                        WHERE %ID > [FROM_IEN]
                                                                        ORDER BY %ID";

        public const string FACILITY_MOVEMENT_TYPE_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                                    NAME, 
                                                                                    ACTIVE 
                                                                FROM [SCHEMA].FACILITY_MOVEMENT_TYPE
                                                                    WHERE %ID > [FROM_IEN]
                                                                    ORDER BY %ID";

        public const string ORDERABLE_ITEM_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                            NAME, 
                                                                            CAST(INACTIVATED AS DATETIME) AS INACTIVATED, 
                                                                            PACKAGE_NAME, 
                                                                            DISPLAY_GROUP 
                                                        FROM [SCHEMA].ORDERABLE_ITEMS_101_43
                                                            WHERE %ID > [FROM_IEN]
                                                            ORDER BY %ID";

        public const string SPECIALTY_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                    NAME 
                                                FROM [SCHEMA].SPECIALTY
                                                    WHERE %ID > [FROM_IEN]
                                                    ORDER BY %ID";

        public const string ORDER_STATUS_QUERY = @"SELECT TOP [ROW_COUNT] IEN, 
                                                                        NAME 
                                                    FROM [SCHEMA].ORDER_STATUS
                                                        WHERE %ID > [FROM_IEN]
                                                        ORDER BY %ID";

        #endregion

        #region WF

        public const string ORDER_QUERY = @"SELECT TOP [ROW_COUNT] O.IEN, 
					                                    O.ORDER_, 
					                                    O.OBJECT_OF_ORDER_PATIENT AS PATIENT, 
					                                    CAST(O.DATE_OF_LAST_ACTIVITY AS DATETIME) AS DATE_OF_LAST_ACTIVITY, 
					                                    CAST(O.DC_DATETIME AS DATETIME) AS DC_DATE, 
					                                    O.PATIENT_LOCATION_HOSPITALLOCATION AS HOSPITAL_LOCATION_IEN, 
					                                    HL.NAME AS HOSPITAL_LOCATION_NAME, 
                                                        HL.ABBREVIATION AS HOSPITAL_LOCATION_ABBREVIATION, 
                                                        HL.TELEPHONE AS HOSPITAL_LOCATION_TELEPHONE, 
                                                        WL.IEN AS WARD_IEN, 
                                                        WL.NAME AS WARD_NAME, 
                                                        WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                        WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME, 
                                                        WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE,
					                                    CAST(O.START_DATE AS DATETIME) AS START_DATE, 
					                                    CAST(O.STOP_DATE AS DATETIME) AS STOP_DATE, 
					                                    O.STATUS, 
					                                    O.STATUS_NAME, 
					                                    O.TO23 AS DISPLAY_GROUP, 
					                                    OI.ORDERABLE_ITEM, 
					                                    CAST(OA.DATETIME_ORDERED AS DATETIME) AS DATE_ORDERED, 
					                                    OA.PROVIDER, 
					                                    OA.PROVIDER_NAME, 
					                                    OA.SIGNED_BY, 
					                                    OA.SIGNED_BY_NAME, 
					                                    CAST(OA.DATETIME_SIGNED AS DATETIME) AS DATE_SIGNED, 
					                                    OA.VERIFYING_NURSE, 
					                                    OA.VERIFYING_NURSE_NAME, 
					                                    CAST(OA.DATETIME_NURSE_VERIFIED AS DATETIME) AS DATE_NURSE_VERIFIED, 
					                                    OA.VERIFYING_CLERK, 
					                                    OA.VERIFYING_CLERK_NAME, 
					                                    CAST(OA.DATETIME_CLERK_VERIFIED AS DATETIME) AS DATE_CLERK_VERIFIED, 
					                                    OA.RELEASE_STATUS, 
					                                    CAST(OA.RELEASE_DATETIME AS DATETIME) AS RELEASE_DATE, 
					                                    OA.SIGNATURE_STATUS, 
					                                    OT.ORDER_TEXT, 
					                                    P.NAME AS PATIENT_NAME, 
					                                    P.SEX AS PATIENT_SEX, 
					                                    CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
					                                    P.SOCIAL_SECURITY_NUMBER, 
					                                    P.f1U4N, 
					                                    P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
					                                    P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
					                                    PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
					                                    P.SERVICE_CONNECTED_PERCENTAGE, 
					                                    P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
					                                    P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
			                                    FROM [SCHEMA].ORDER AS O                                                    
				                                    LEFT JOIN [SCHEMA].ORDER_ACTIONS AS OA ON O.IEN = OA.ORDER
				                                    LEFT JOIN [SCHEMA].ORDER_TEXT AS OT ON OA.RowId = OT.ORDER_ACTIONS
				                                    LEFT JOIN [SCHEMA].PATIENT AS P ON O.OBJECT_OF_ORDER_PATIENT = P.IEN
				                                    LEFT JOIN [SCHEMA].ORDERABLE_ITEMS AS OI ON O.IEN = OI.ORDER
				                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN								
				                                    LEFT JOIN [SCHEMA].HOSPITAL_LOCATION AS HL ON O.PATIENT_LOCATION_HOSPITALLOCATION = HL.IEN
                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.HOSPITAL_LOCATION_FILE_POINTER = HL.IEN
			                                    WHERE CAST(O.DATE_OF_LAST_ACTIVITY AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND CAST(O.DATE_OF_LAST_ACTIVITY AS DATETIME) <= CAST([END_DATE] AS DATETIME)
					                                    AND O.IEN > [FROM_IEN] AND O.STATUS_NAME = 'ACTIVE' 
                                                ORDER BY O.IEN";

        public const string CANCELLED_ORDER_QUERY = @"SELECT IEN
                                                FROM [SCHEMA].ORDER                                                    
                                                    WHERE IEN IN ([CANCELLED_ORDER_IENS]) AND STATUS_NAME = 'CANCELLED'";

        public const string PATIENT_APPOINTMENT_QUERY = @"SELECT TOP [ROW_COUNT] A.%ID AS IEN, 
                                                                            A.PATIENT, 
                                                                            CAST(AL.APPOINTMENT_DATETIME AS DATETIME) AS APPOINTMENT_DATETIME, 
                                                                            STATUS, 
                                                                            CAST(DATE_APPT__MADE AS DATETIME) AS DATE_APPOINTMENT_MADE, 
                                                                            CURRENT_STATUS, 
                                                                            AL.HOSPITAL_LOCATION AS HOSPITAL_LOCATION_IEN, 
                                                                            HL.NAME AS HOSPITAL_LOCATION_NAME, 
                                                                            HL.ABBREVIATION AS HOSPITAL_LOCATION_ABBREVIATION, 
                                                                            HL.TELEPHONE AS HOSPITAL_LOCATION_TELEPHONE, 
                                                                            WL.IEN AS WARD_IEN, 
                                                                            WL.NAME AS WARD_NAME, 
                                                                            WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                            WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME, 
                                                                            WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE,
                                                                            TELEPHONE_OF_CLINIC, 
                                                                            P.NAME AS PATIENT_NAME, 
                                                                            P.SEX AS PATIENT_SEX, 
                                                                            CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                            P.SOCIAL_SECURITY_NUMBER, 
                                                                            P.f1U4N, 
                                                                            P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                            P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                            PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                            P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                            P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                            P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
                                                                FROM [SCHEMA].APPOINTMENT AS A
                                                                    LEFT JOIN [SCHEMA].APPOINTMENT_44_001 AS AL ON A.IEN = AL.IEN
                                                                    LEFT JOIN [SCHEMA].PATIENT AS P ON A.PATIENT = P.IEN
                                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN
                                                                    LEFT JOIN [SCHEMA].HOSPITAL_LOCATION AS HL ON HL.IEN = AL.HOSPITAL_LOCATION
                                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.HOSPITAL_LOCATION_FILE_POINTER = HL.IEN
                                                                WHERE CAST(AL.APPOINTMENT_DATETIME AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND A.%ID > [FROM_IEN] 
                                                                ORDER BY A.%ID";

        public const string PATIENT_MOVEMENT_QUERY = @"SELECT TOP [ROW_COUNT] PM.IEN, 
                                                                        CAST(PM.DATETIME AS DATETIME) AS DATE_TIME, 
                                                                        PM.PATIENT, 
                                                                        PM.TRANSACTION_02 AS TRANSACTION_ID,
                                                                        PM.TYPE_OF_MOVEMENT, 
                                                                        PM.TYPE_OF_MOVEMENT_NAME, 
                                                                        PM.WARD_LOCATION AS WARD_IEN, 
                                                                        WL.NAME AS WARD_NAME, 
                                                                        WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                        WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME,
                                                                        WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE, 
                                                                        PM.ROOMBED AS RB_IEN, 
                                                                        RB.NAME AS RB_NAME, 
                                                                        RB.CURRENTLY_OUTOFSERVICE AS RB_OUT_OF_SERVICE, 
                                                                        WW.IEN AS RB_WARD_IEN, 
                                                                        RBWL.NAME AS RB_WARD_NAME, 
                                                                        RBWL.SPECIALTY AS RB_WARD_SPECIALTY_IEN, 
                                                                        RBWL.SPECIALTY_NAME AS RB_WARD_SPECIALTY_NAME,                                                                         
                                                                        RBWL.CURRENTLY_OUTOFSERVICE AS RB_WARD_OUT_OF_SERVICE, 
                                                                        CAST(RBO.OUTOFSERVICE_DATE AS DATETIME) AS RB_OUT_OF_SERVICE_DATE, 
                                                                        RB.BED_HOLD, RB.BED_HOLD_DATE, 
                                                                        PM.ENTERED_BY, 
                                                                        NP.NAME AS ENTERED_BY_NAME, 
                                                                        CAST(PM.ENTERED_ON AS DATETIME) AS ENTERED_ON_DATETIME, 
                                                                        P.NAME AS PATIENT_NAME, 
                                                                        P.SEX AS PATIENT_SEX, 
                                                                        CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                        P.SOCIAL_SECURITY_NUMBER, 
                                                                        P.f1U4N, 
                                                                        P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                        P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                        PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                        P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                        P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                        P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME,
                                                                        PM.ADMISSIONCHECKIN_MOVEMENT AS CURRENT_ADMISSION
                                                            FROM [SCHEMA].PATIENT_MOVEMENT AS PM
                                                                LEFT JOIN [SCHEMA].PATIENT AS P ON PM.PATIENT = P.IEN
		                                                        LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM1 ON P.CURRENT_ADMISSION = PM1.IEN
		                                                        LEFT JOIN [SCHEMA].NEW_PERSON AS NP ON PM.ENTERED_BY = NP.IEN
		                                                        LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.IEN = PM.WARD_LOCATION		                                                        
		                                                        LEFT JOIN [SCHEMA].ROOMBED AS RB ON PM.ROOMBED = RB.IEN
		                                                        LEFT JOIN [SCHEMA].WARDS_WHICH_CAN_ASSIGN AS WW ON RB.IEN = WW.ROOMBED
		                                                        LEFT JOIN [SCHEMA].OUTOFSERVICE_DATE AS RBO ON RB.IEN = RBO.ROOMBED AND 
                                                                                        (CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) >= GETDATE() OR CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) IS NULL)
		                                                        LEFT JOIN [SCHEMA].WARD_LOCATION AS RBWL ON WW.IEN = RBWL.IEN
                                                            WHERE CAST(PM.DATETIME AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND CAST(PM.DATETIME AS DATETIME) <= CAST([END_DATE] AS DATETIME)
                                                                        AND PM.IEN > [FROM_IEN] 
                                                            ORDER BY PM.IEN";

        public const string PATIENT_MOVEMENT_BY_PATIENT_IEN_QUERY = @"SELECT PM.IEN, 
                                                                    CAST(PM.DATETIME AS DATETIME) AS DATE_TIME, 
                                                                    PM.PATIENT, 
                                                                    PM.TRANSACTION_02 AS TRANSACTION_ID,
                                                                    PM.TYPE_OF_MOVEMENT, 
                                                                    PM.TYPE_OF_MOVEMENT_NAME, 
                                                                    PM.WARD_LOCATION AS WARD_IEN, 
                                                                    WL.NAME AS WARD_NAME, 
                                                                    WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                    WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME,
                                                                    WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE, 
                                                                    PM.ROOMBED AS RB_IEN, 
                                                                    RB.NAME AS RB_NAME, 
                                                                    RB.CURRENTLY_OUTOFSERVICE AS RB_OUT_OF_SERVICE, 
                                                                    WW.IEN AS RB_WARD_IEN, 
                                                                    RBWL.NAME AS RB_WARD_NAME, 
                                                                    RBWL.SPECIALTY AS RB_WARD_SPECIALTY_IEN, 
                                                                    RBWL.SPECIALTY_NAME AS RB_WARD_SPECIALTY_NAME,                                                                     
                                                                    RBWL.CURRENTLY_OUTOFSERVICE AS RB_WARD_OUT_OF_SERVICE, 
                                                                    CAST(RBO.OUTOFSERVICE_DATE AS DATETIME) AS RB_OUT_OF_SERVICE_DATE, 
                                                                    RB.BED_HOLD, 
                                                                    RB.BED_HOLD_DATE, 
                                                                    PM.ENTERED_BY, 
                                                                    NP.NAME AS ENTERED_BY_NAME, 
                                                                    CAST(PM.ENTERED_ON AS DATETIME) AS ENTERED_ON_DATETIME, 
                                                                    P.NAME AS PATIENT_NAME, 
                                                                    P.SEX AS PATIENT_SEX, 
                                                                    CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                    P.SOCIAL_SECURITY_NUMBER, 
                                                                    P.f1U4N, 
                                                                    P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                    P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                    PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                    P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                    P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                    P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME,
                                                                    PM.ADMISSIONCHECKIN_MOVEMENT AS CURRENT_ADMISSION
                                                        FROM [SCHEMA].PATIENT_MOVEMENT AS PM
                                                            LEFT JOIN [SCHEMA].PATIENT AS P ON PM.PATIENT = P.IEN
		                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM1 ON P.CURRENT_ADMISSION = PM1.IEN
		                                                    LEFT JOIN [SCHEMA].NEW_PERSON AS NP ON PM.ENTERED_BY = NP.IEN
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.IEN = PM.WARD_LOCATION		                                                    
		                                                    LEFT JOIN [SCHEMA].ROOMBED AS RB ON PM.ROOMBED = RB.IEN
		                                                    LEFT JOIN [SCHEMA].WARDS_WHICH_CAN_ASSIGN AS WW ON RB.IEN = WW.ROOMBED
		                                                    LEFT JOIN [SCHEMA].OUTOFSERVICE_DATE AS RBO ON RB.IEN = RBO.ROOMBED AND 
                                                                                    (CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) >= GETDATE() OR CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) IS NULL)
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS RBWL ON WW.IEN = RBWL.IEN		                                                    
                                                        WHERE P.IEN = [PATIENT_MOVEMENT_PATIENT_IEN] AND PM.DATETIME = CAST([PATIENT_MOVEMENT_DATE_TIME] AS DATETIME) AND PM.TRANSACTION_02 = [PATIENT_MOVEMENT_TRANSACTION]";

        public const string PATIENT_MOVEMENT_BY_ADMISSION_QUERY = @"SELECT PM.IEN, 
                                                                    CAST(PM.DATETIME AS DATETIME) AS DATE_TIME, 
                                                                    PM.PATIENT, 
                                                                    PM.TRANSACTION_02 AS TRANSACTION_ID,
                                                                    PM.TYPE_OF_MOVEMENT, 
                                                                    PM.TYPE_OF_MOVEMENT_NAME, 
                                                                    PM.WARD_LOCATION AS WARD_IEN, 
                                                                    WL.NAME AS WARD_NAME, 
                                                                    WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                    WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME,
                                                                    WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE, 
                                                                    PM.ROOMBED AS RB_IEN, 
                                                                    RB.NAME AS RB_NAME, 
                                                                    RB.CURRENTLY_OUTOFSERVICE AS RB_OUT_OF_SERVICE, 
                                                                    WW.IEN AS RB_WARD_IEN, 
                                                                    RBWL.NAME AS RB_WARD_NAME, 
                                                                    RBWL.SPECIALTY AS RB_WARD_SPECIALTY_IEN, 
                                                                    RBWL.SPECIALTY_NAME AS RB_WARD_SPECIALTY_NAME,                                                                     
                                                                    RBWL.CURRENTLY_OUTOFSERVICE AS RB_WARD_OUT_OF_SERVICE, 
                                                                    CAST(RBO.OUTOFSERVICE_DATE AS DATETIME) AS RB_OUT_OF_SERVICE_DATE, 
                                                                    RB.BED_HOLD, 
                                                                    RB.BED_HOLD_DATE, 
                                                                    PM.ENTERED_BY, 
                                                                    NP.NAME AS ENTERED_BY_NAME, 
                                                                    CAST(PM.ENTERED_ON AS DATETIME) AS ENTERED_ON_DATETIME, 
                                                                    P.NAME AS PATIENT_NAME, 
                                                                    P.SEX AS PATIENT_SEX, 
                                                                    CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                    P.SOCIAL_SECURITY_NUMBER, 
                                                                    P.f1U4N, 
                                                                    P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                    P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                    PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                    P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                    P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                    P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME,
                                                                    PM.ADMISSIONCHECKIN_MOVEMENT AS CURRENT_ADMISSION
                                                        FROM [SCHEMA].PATIENT_MOVEMENT AS PM
                                                            LEFT JOIN [SCHEMA].PATIENT AS P ON PM.PATIENT = P.IEN
		                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM1 ON P.CURRENT_ADMISSION = PM1.IEN
		                                                    LEFT JOIN [SCHEMA].NEW_PERSON AS NP ON PM.ENTERED_BY = NP.IEN
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.IEN = PM.WARD_LOCATION		                                                    
		                                                    LEFT JOIN [SCHEMA].ROOMBED AS RB ON PM.ROOMBED = RB.IEN
		                                                    LEFT JOIN [SCHEMA].WARDS_WHICH_CAN_ASSIGN AS WW ON RB.IEN = WW.ROOMBED
		                                                    LEFT JOIN [SCHEMA].OUTOFSERVICE_DATE AS RBO ON RB.IEN = RBO.ROOMBED AND 
                                                                                    (CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) >= GETDATE() OR CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) IS NULL)
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS RBWL ON WW.IEN = RBWL.IEN		                                                    
                                                        WHERE PM.ADMISSIONCHECKIN_MOVEMENT = [PATIENT_MOVEMENT_ADMISSION_IEN]";

        public const string BED_SWITCH_QUERY = @"SELECT IEN, WARD_LOCATION, ROOMBED
                                                        FROM [SCHEMA].PATIENT_MOVEMENT 
                                                        WHERE IEN IN ([PATIENT_MOVEMENT_IENS])";

        public const string SCHEDULED_ADMISSION_QUERY = @"SELECT TOP [ROW_COUNT] S.IEN, 
		                                                            S.PATIENT, 
		                                                            CAST(S.RESERVATION_DATETIME AS DATETIME) AS RESERVATION_DATETIME, 
		                                                            S.LENGTH_OF_STAY_EXPECTED, 
                                                                    S.ADMITTING_DIAGNOSIS, 
                                                                    S.PROVIDER, 
                                                                    S.PROVIDER_NAME, 
                                                                    S.PERSON_SCHEDULING_ADMIT AS SCHEDULER, 
                                                                    S.PERSON_SCHEDULING_ADMIT_NAME AS SCHEDULER_NAME,
                                                                    S.SURGERY, 
                                                                    S.WARD AS WARD_IEN, 
                                                                    WL.NAME AS WARD_NAME, 
                                                                    WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                    WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME,                                                                    
                                                                    WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE,  
                                                                    S.TREATING_SPECIALTY, 
                                                                    S.TREATING_SPECIALTY_NAME, 
                                                                    S.DIVISION, 
                                                                    S.DIVISION_NAME, 
                                                                    CAST(S.DATETIME_CANCELLED AS DATETIME) AS DATETIME_CANCELLED, 
                                                                    S.CANCELLED_BY, 
                                                                    S.CANCELLED_BY_NAME AS CANCELLED_BY_NAME, 
                                                                    P.NAME AS PATIENT_NAME, 
                                                                    P.SEX AS PATIENT_SEX, 
                                                                    CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                    P.SOCIAL_SECURITY_NUMBER, 
                                                                    P.f1U4N, 
                                                                    P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                    P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                    PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                    P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                    P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                    P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME
                                                            FROM [SCHEMA].SCHEDULED_ADMISSION AS S
                                                                LEFT JOIN [SCHEMA].PATIENT AS P ON S.PATIENT = P.IEN
                                                                LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM ON P.CURRENT_ADMISSION = PM.IEN            
                                                                LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON S.WARD = WL.IEN                                                                
                                                            WHERE CAST(S.RESERVATION_DATETIME AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND S.IEN > [FROM_IEN] ";

        public const string ADMITTED_PATIENTS_QUERY = @"SELECT IEN, NAME, SOCIAL_SECURITY_NUMBER, CURRENT_ADMISSION, CURRENT_MOVEMENT
                                                        FROM [SCHEMA].PATIENT
                                                            WHERE CURRENT_ADMISSION IS NOT NULL AND CURRENT_ADMISSION < [CURRENT_ADMISSION_IEN] AND IEN > [FROM_IEN] ";

        public const string PATIENT_MOVEMENT_IENS_QUERY = @"SELECT PM.IEN, 
                                                                   CAST(PM.DATETIME AS DATETIME) AS DATE_TIME
                                                            FROM [SCHEMA].PATIENT_MOVEMENT AS PM                                                                
                                                            WHERE CAST(PM.DATETIME AS DATETIME) >= CAST([START_DATE] AS DATETIME) AND CAST(PM.DATETIME AS DATETIME) <= CAST([END_DATE] AS DATETIME)                                                                        
                                                            ORDER BY PM.IEN";

        public const string PATIENT_MOVEMENT_BY_IEN_QUERY = @"SELECT PM.IEN, 
                                                                    CAST(PM.DATETIME AS DATETIME) AS DATE_TIME, 
                                                                    PM.PATIENT, 
                                                                    PM.TRANSACTION_02 AS TRANSACTION_ID,
                                                                    PM.TYPE_OF_MOVEMENT, 
                                                                    PM.TYPE_OF_MOVEMENT_NAME, 
                                                                    PM.WARD_LOCATION AS WARD_IEN, 
                                                                    WL.NAME AS WARD_NAME, 
                                                                    WL.SPECIALTY AS WARD_SPECIALTY_IEN, 
                                                                    WL.SPECIALTY_NAME AS WARD_SPECIALTY_NAME,
                                                                    WL.CURRENTLY_OUTOFSERVICE AS WARD_CURRENTLY_OUTOFSERVICE, 
                                                                    PM.ROOMBED AS RB_IEN, 
                                                                    RB.NAME AS RB_NAME, 
                                                                    RB.CURRENTLY_OUTOFSERVICE AS RB_OUT_OF_SERVICE, 
                                                                    WW.IEN AS RB_WARD_IEN, 
                                                                    RBWL.NAME AS RB_WARD_NAME, 
                                                                    RBWL.SPECIALTY AS RB_WARD_SPECIALTY_IEN, 
                                                                    RBWL.SPECIALTY_NAME AS RB_WARD_SPECIALTY_NAME,                                                                     
                                                                    RBWL.CURRENTLY_OUTOFSERVICE AS RB_WARD_OUT_OF_SERVICE, 
                                                                    CAST(RBO.OUTOFSERVICE_DATE AS DATETIME) AS RB_OUT_OF_SERVICE_DATE, 
                                                                    RB.BED_HOLD, 
                                                                    RB.BED_HOLD_DATE, 
                                                                    PM.ENTERED_BY, 
                                                                    NP.NAME AS ENTERED_BY_NAME, 
                                                                    CAST(PM.ENTERED_ON AS DATETIME) AS ENTERED_ON_DATETIME, 
                                                                    P.NAME AS PATIENT_NAME, 
                                                                    P.SEX AS PATIENT_SEX, 
                                                                    CAST(P.DATE_OF_BIRTH AS DATETIME) AS PATIENT_DATE_OF_BIRTH, 
                                                                    P.SOCIAL_SECURITY_NUMBER, 
                                                                    P.f1U4N, 
                                                                    P.TREATING_SPECIALTY AS PATIENT_TREATING_SPECIALTY, 
                                                                    P.TREATING_SPECIALTY_NAME AS PATIENT_TREATING_SPECIALTY_NAME, 
                                                                    PM.DIAGNOSIS_SHORT AS DIAGNOSIS, 
                                                                    P.SERVICE_CONNECTED_PERCENTAGE, 
                                                                    P.ATTENDING_PHYSICIAN AS PATIENT_ATTENDING_PHYSICIAN, 
                                                                    P.ATTENDING_PHYSICIAN_NAME AS PATIENT_ATTENDING_PHYSICIAN_NAME,
                                                                    PM.ADMISSIONCHECKIN_MOVEMENT AS CURRENT_ADMISSION
                                                        FROM [SCHEMA].PATIENT_MOVEMENT AS PM
                                                            LEFT JOIN [SCHEMA].PATIENT AS P ON PM.PATIENT = P.IEN
		                                                    LEFT JOIN [SCHEMA].PATIENT_MOVEMENT AS PM1 ON P.CURRENT_ADMISSION = PM1.IEN
		                                                    LEFT JOIN [SCHEMA].NEW_PERSON AS NP ON PM.ENTERED_BY = NP.IEN
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS WL ON WL.IEN = PM.WARD_LOCATION		                                                    
		                                                    LEFT JOIN [SCHEMA].ROOMBED AS RB ON PM.ROOMBED = RB.IEN
		                                                    LEFT JOIN [SCHEMA].WARDS_WHICH_CAN_ASSIGN AS WW ON RB.IEN = WW.ROOMBED
		                                                    LEFT JOIN [SCHEMA].OUTOFSERVICE_DATE AS RBO ON RB.IEN = RBO.ROOMBED AND 
                                                                                    (CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) >= GETDATE() OR CAST(RBO.RETURN_TO_SERVICE_DATE AS DATETIME) IS NULL)
		                                                    LEFT JOIN [SCHEMA].WARD_LOCATION AS RBWL ON WW.IEN = RBWL.IEN		                                                    
                                                        WHERE PM.IEN = [PATIENT_MOVEMENT_IEN] ";

        #endregion
    }
}
